<?php
/* =====================================================================
 * podio_backup.php
 * This script backs up your entire Podio account.
 * (c) 2013 Globi Web Solutions
 * v1.2 2013-05-04 - Andreas Huttenrauch
 *
 *  Please post something nice on your website / blog and link back to www.globi.ca if you find this script useful. 
 * ===================================================================== */

require_once('podio-php-master/PodioAPI.php'); // include the php Podio Master Class
$config['backupTo'] = "backups";
$verbose = true;
if (isset($_GET['verbose']) && $_GET['verbose']=="off") $verbose = false;

if (isset($_POST['action']) && $_POST['action']=="podioupdate") update_config();

check_backup_folder();
read_config();
if (check_config()) {
	do_backup();
} else {
	edit_config();
}


function check_backup_folder() {
global $config;
	$folder = $config['backupTo'];
	if (!is_dir($folder)) {
		show_error ( "ERROR: create a backup folder called '".$folder."'" );
		exit();
	}	
	if (!is_writeable($folder)) {
		show_error ( "ERROR: please make sure that the ".$folder." directory is writeable and has 777 permissions set" );
		exit();
	}	
	if (!file_exists($folder."/.htaccess")) {
		file_put_contents($folder."/.htaccess", "deny from all\n");
	}
} // END check_backup_folder

function check_config() {
global $config;
	Podio::$debug = true;
	try {
		Podio::setup($config['podioClientId'], $config['podioClientSecret']);
	}
	catch (PodioError $e) {
		show_error ( "ERROR: Podio Authentication Failed. Please check the API key and user details." );
		return false;
	}
	try {
		Podio::authenticate('password', array('username' => $config['podioUser'], 'password' => $config['podioPassword']));
	}
	catch (PodioError $e) {
		show_error ( "ERROR: Podio Authentication Failed. Please check the API key and user details." );
		return false;
	}
	if (!Podio::is_authenticated()) {
		show_error ( "ERROR: Podio Authentication Failed. Please check the API key and user details." );
		return false;
	}
	return true;
} // END check_config


function read_config() {
global $config;
	$config['podioClientId'] = '';
	$config['podioClientSecret'] = '';
	$config['podioUser'] = '';
	$config['podioPassword'] = '';
	if (!file_exists($config['backupTo']."/podio_backup_vars.php")) {
		write_config();
	}
	$data = file_get_contents($config['backupTo']."/podio_backup_vars.php");
	$config = unserialize($data);
} // END read_config

function write_config() {
global $config;
	$data = serialize($config);
	file_put_contents($config['backupTo']."/podio_backup_vars.php", $data);
} // END write_config

// begin configuration

function update_config() {
global $config;
	$config['podioClientId'] = clean($_POST['podioClientId']);
	$config['podioClientSecret'] = clean($_POST['podioClientSecret']);
	$config['podioUser'] = clean($_POST['podioUser']);
	$config['podioPassword'] = clean($_POST['podioPassword']);
	write_config();
} // END update_config

function edit_config() {
global $config;
?>
<form action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<input type="hidden" name="action" value="podioupdate" />
<table>
	<tr>
		<td>Podio Client ID:</td>
		<td><input type="text" name="podioClientId" size="20" value="<?php echo $config['podioClientId']; ?>" /></td>
	</tr>
	<tr>
		<td>Podio Client Secret:</td>
		<td><input type="text" name="podioClientSecret" size="60" value="<?php echo $config['podioClientSecret']; ?>" /></td>
	</tr>
	<tr>
		<td>Podio Username:</td>
		<td><input type="text" name="podioUser" size="40" value="<?php echo $config['podioUser']; ?>" /></td>
	</tr>
	<tr>
		<td>Podio User Password:</td>
		<td><input type="text" name="podioPassword" size="40" value="<?php echo $config['podioPassword']; ?>" /></td>
	</tr>
	<tr>
		<td>&nbsp;</td>
		<td><input type="submit" value="Save" /></td>
	</tr>
</table>
</form>	
<p>Note1: To get the Podio Client ID and Secret, go to My Account > Account Settings > API Keys</p>
<p>Note2: We recommend creating a new Podio user for automation, and make sure this user is a member of all Workspaces in order to be able to perform the backups</p>
<?php
} // END edit_config

function show_error($error) {
	echo "<p style='font-size: 16px; color: red; padding: 5px; border: 1px solid red;'>".$error."</p>";
} // END show_error

function show_success($message) {
	echo "<p style='font-size: 16px; color: green; padding: 5px; border: 1px solid green;'>".$message."</p>";
} // END show_error

function clean($value) {
	$value = trim(htmlspecialchars($value, ENT_QUOTES, "utf-8")); //convert input into friendly characters to stop XSS
	return $value;
} // END clean

function do_backup() {
global $config, $verbose;
	$currentdir = getcwd();
	$timeStamp = date('YmdHi');
	$backupTo = $config['backupTo'];
	
	mkdir($backupTo.'/'.$timeStamp);

	$podioOrgs = PodioOrganization::get_all(  );
	
	foreach ($podioOrgs as $org) { //org_id
		if ($verbose) echo "Organization: ".$org->name."<br>";
		mkdir($backupTo.'/'.$timeStamp.'/'.$org->name);
		
		$contacts = PodioContact::get_for_org( $org->org_id );
		$contactsFile = serialize($contacts);
		file_put_contents($backupTo.'/'.$timeStamp.'/'.$org->name.'/'.'podio_organization_contacts.txt', $contactsFile);
		
		foreach ($org->spaces as $space) { // space_id
	
			if ($verbose) echo "Workspace: ".$space->name."<br>";
			mkdir($backupTo.'/'.$timeStamp.'/'.$org->name.'/'.$space->name);
			
			$contacts = PodioContact::get_for_space( $space->space_id);
			$contactsFile = serialize($contacts);
			
			file_put_contents($backupTo.'/'.$timeStamp.'/'.$org->name.'/'.$space->name.'/'.'podio_space_contacts.txt', $contactsFile);
			
			$spaceApps = PodioApp::get_for_space( $space->space_id);
			
			foreach ($spaceApps as $app) {
	
				if ($verbose) echo "App: ".$app->config['name']."<br>";
				
				$itemFile = PodioItem::xlsx( $app->app_id , array("limit" => 1000) );
				file_put_contents($backupTo.'/'.$timeStamp.'/'.$org->name.'/'.$space->name.'/'.$app->config['name'].'.xlsx', $itemFile);
				
			}
	
		}
		
	}
	
	if ($verbose) show_success ("Backup Completed successfully to ".$currentdir."/".$backupTo."/".$timeStamp); 
}

?>
